within ;
model EngineTestBench

  Engine engine(
    tableNamePower="C7.txt",
    tableNameTorque="C7.txt")
    annotation (Placement(transformation(extent={{-48,30},{-28,50}})));
  Modelica.Blocks.Sources.Constant const(k=1)
    annotation (Placement(transformation(extent={{-86,30},{-66,50}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=1)
    annotation (Placement(transformation(extent={{-12,30},{8,50}})));
  Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction
    annotation (Placement(transformation(extent={{20,30},{40,50}})));
equation
  connect(const.y, engine.u) annotation (Line(
      points={{-65,40},{-48,40}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(engine.flange_b, inertia.flange_a) annotation (Line(
      points={{-28,40},{-12,40}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, bearingFriction.flange_a) annotation (Line(
      points={{8,40},{20,40}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end EngineTestBench;
